---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-スペクトル操作（Spectral Operations）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、特に優先的なレビュー項目はない

## 2) 参照した情報（Evidence一覧）
- E-01: `tensorflow/core/ops/spectral_ops.cc` 全体（235行）
- E-02: `tensorflow/core/ops/spectral_ops.cc` 27-33行目 FFT登録
- E-03: `tensorflow/core/ops/spectral_ops.cc` 95-130行目 RFFTShape関数
- E-04: `tensorflow/core/ops/spectral_ops.cc` 132-138行目 RFFT登録
- E-05: `tensorflow/core/ops/spectral_ops.cc` 202-232行目 非推奨Batch系

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FFT/IFFTは複素数入出力で形状不変 | E-02 | ○ |
| C-02 | RFFTの最後の次元出力サイズは fft_length/2 + 1 | E-03(121-123行目) | ○ |
| C-03 | IRFFTの最後の次元出力サイズはfft_lengthそのもの | E-03(121-123行目) | ○ |
| C-04 | fft_length入力はrank=1でdim[0]=対応ランク | E-03(101-106行目) | ○ |
| C-05 | FFT2D/IFFT2Dはrank>=2を要求 | E-01(43-57行目) | ○ |
| C-06 | FFT3D/IFFT3Dはrank>=3を要求 | E-01(59-73行目) | ○ |
| C-07 | FFTND/IFFTNDはaxes入力で適用軸を指定 | E-01(75-93行目) | ○ |
| C-08 | Tcomplex属性のデフォルトはDT_COMPLEX64 | E-02(30行目) | ○ |
| C-09 | Treal属性のデフォルトはDT_FLOAT | E-04(136行目) | ○ |
| C-10 | BatchFFT系はバージョン15で非推奨 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Op定義はシンプルで明確

## 6) レビュアーチェックリスト（最小）
- [ ] RFFTの出力次元計算（fft_length/2+1）が正しく記載されているか確認
- [ ] FFTND/IFFTNDのaxes入力の役割が正しいか確認
- [ ] 非推奨Opの代替先が正しいか確認
